﻿//////////////////////////////////////////////
// FilmGrainProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "FilmGrainEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct FilmGrainProgramIdGenerator
	{
		static unsigned long long generate (const FilmGrainEffectInfo& info) ;
	} ;

	struct FilmGrainProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_FILM_GRAIN_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class FilmGrainProgramTracker final : public ProgramTracker<FilmGrainEffectInfo, FilmGrainProgramIdGenerator, FilmGrainProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			FilmGrainProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~FilmGrainProgramTracker () ;
	} ;
}